﻿Imports System.Text
Public Class RS_232C_USB

    '(0)クラス内変数
    Private SerialPort As System.IO.Ports.SerialPort                                    'シリアルポートデバイス
    Public MsgBuf As String = ""                                                        '受信データ

    '(1)接続
    Public Function OpenInterface(ByVal port As String, ByVal speed As String) As Boolean
        Dim ret As Boolean = False

        Try
            SerialPort = New System.IO.Ports.SerialPort                                 'シリアルポートオブジェクトを作成
            SerialPort.PortName = port                                                  'COMポートを設定
            SerialPort.BaudRate = Convert.ToInt32(speed)                                'スピードを設定
            SerialPort.Open()                                                           'シリアルポートオープン
            ret = True
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try

        OpenInterface = ret
    End Function

    '(2)切断
    Public Function CloseInterface() As Boolean
        Dim ret As Boolean = False

        Try
            If SerialPort.IsOpen Then
                SerialPort.Close()                                                      'シリアルポートクローズ
            End If
            SerialPort.Dispose()                                                        ''シリアルポートオブジェクトを廃棄
            ret = True
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

        CloseInterface = ret
    End Function

    '(3)コマンド送信
    Public Function SendMsg(ByVal strMsg As String) As Boolean
        Dim ret As Boolean = False

        Try
            strMsg += vbCrLf                                                            'ターミネータ「CR+LF」を付加
            SerialPort.Write(strMsg)                                                    '送信バッファに書き込み
            ret = True
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try

        SendMsg = ret
    End Function

    '(4)受信
    Public Function ReceiveMsg(ByVal timeout_ms As Long) As Boolean
        Dim ret As Boolean = False
        Dim rcv As String = ""
        Dim buf As New StringBuilder()
        Dim sw As New Stopwatch()

        Try
            MsgBuf = ""                                                                 '受信データをクリア

            sw.Start()                                                                  'タイムアウト用ストップウォッチを開始
            'ターミネータ「LF」を受信するまでループ
            Do
                If SerialPort.BytesToRead > 0 Then
                    rcv = SerialPort.ReadExisting()                                     '受信バッファにデータがあれば読み取り
                    rcv = rcv.Replace(vbCr, "")                                         '受信データ内の「CR」を削除
                    If rcv.IndexOf(vbLf) >= 0 Then                                      'ターミネータ「LF」を受信したら終了
                        rcv = rcv.Substring(0, rcv.IndexOf(vbLf))                       '受信データを「LF」の手前までで切り詰め
                        buf.Append(rcv)                                                 '受信データを保存
                        MsgBuf = buf.ToString()
                        Exit Do
                    Else
                        buf.Append(rcv)                                                 '受信データを保存
                    End If
                End If
                'タイムアウト処理
                If sw.ElapsedMilliseconds > timeout_ms Then
                    MsgBuf = "Timeout"
                    MsgBox(MsgBuf)
                    ReceiveMsg = ret
                    Exit Function
                End If
            Loop
            sw.Stop()                                                                   'ストップウォッチを停止
            ret = True

        Catch Ex As Exception
            MsgBuf = "Error"
            MsgBox(Ex.Message)
        End Try

        ReceiveMsg = ret
    End Function

    '(5)コマンド送受信
    Public Function SendQueryMsg(ByVal strMsg As String, ByVal timeout_ms As Long) As Boolean
        Dim ret As Boolean = False

        If SerialPort.BytesToRead > 0 Then
            SerialPort.ReadExisting()                                                   '受信バッファにデータがあれば読み取り
        End If

        ret = SendMsg(strMsg)                                                           'コマンド送信
        If ret Then
            If InStr(strMsg, "?") <> 0 Then
                ret = ReceiveMsg(timeout_ms)                                            '送信が成功したら応答を受信
            End If
        End If

        SendQueryMsg = ret
    End Function


End Class
